/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.blueprint.core.util.modification;

import com.google.common.collect.HashMultimap;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.mojang.datafixers.util.Pair;
import com.teamabnormals.blueprint.core.Blueprint;
import com.teamabnormals.blueprint.core.util.modification.ObjectModifier;
import com.teamabnormals.blueprint.core.util.modification.ObjectModifierGroup;
import com.teamabnormals.blueprint.core.util.modification.ObjectModifierSerializerRegistry;
import com.teamabnormals.blueprint.core.util.modification.selection.SelectionSpace;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.commands.Commands;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.ReloadableServerResources;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.EventPriority;

public class ObjectModificationManager<T, S, D>
extends SimpleJsonResourceReloadListener {
    public static final String MAIN_PATH = "modifiers";
    private static final HashMultimap<String, Initializer<?>> INITIALIZER_MAP = HashMultimap.create();
    protected final EnumMap<EventPriority, Map<ResourceLocation, List<ObjectModifier<T, S, D, ?>>>> prioritizedAssignedModifiers = new EnumMap(EventPriority.class);
    private final String type;
    private final ObjectModifierSerializerRegistry<T, S, D> serializerRegistry;
    private final Function<ResourceLocation, D> additionalDeserializationGetter;
    private final boolean logSkipping;
    private final boolean allowPriority;
    protected SelectionSpace selectionSpace = consumer -> {};

    public ObjectModificationManager(Gson gson, String directory, @Nullable String targetDirectory, String type, ObjectModifierSerializerRegistry<T, S, D> serializerRegistry, Function<ResourceLocation, D> additionalDeserializationGetter, boolean logSkipping, boolean allowPriority) {
        super(gson, "modifiers/" + directory);
        this.type = type;
        this.serializerRegistry = serializerRegistry;
        this.additionalDeserializationGetter = additionalDeserializationGetter;
        this.logSkipping = logSkipping;
        this.allowPriority = allowPriority;
        if (targetDirectory != null) {
            MinecraftForge.EVENT_BUS.addListener(event -> {
                if (event.getDirectory().equals(targetDirectory)) {
                    Set<ResourceLocation> entries = event.getEntries().keySet();
                    this.selectionSpace = entries::forEach;
                }
            });
        }
    }

    public ObjectModificationManager(Gson gson, String directory, @Nullable String targetDirectory, String type, ObjectModifierSerializerRegistry<T, S, D> serializerRegistry, D additionalDeserializationObject, boolean logSkipping, boolean allowPriority) {
        this(gson, directory, targetDirectory, type, (ObjectModifierSerializerRegistry<T, S, Function<ResourceLocation, Object>>)serializerRegistry, location -> additionalDeserializationObject, logSkipping, allowPriority);
    }

    public static synchronized <OM extends ObjectModificationManager<?, ?, ?>> void registerInitializer(@Nullable String targetListener, Initializer<OM> initializer) {
        INITIALIZER_MAP.put((Object)targetListener, initializer);
    }

    public static void processInitializers(RegistryAccess.Frozen registryAccess, Commands.CommandSelection commandSelection, ReloadableServerResources reloadableServerResources, List<PreparableReloadListener> listeners) {
        ArrayList<Pair> initialized = new ArrayList<Pair>();
        for (int i = 0; i < listeners.size(); ++i) {
            Set initializers = INITIALIZER_MAP.get((Object)listeners.get(i).m_7812_());
            for (Initializer initializer2 : initializers) {
                initialized.add(Pair.of((Object)i, initializer2.init(registryAccess, commandSelection, reloadableServerResources)));
            }
        }
        initialized.forEach(pair -> listeners.add((Integer)pair.getFirst(), (PreparableReloadListener)pair.getSecond()));
        INITIALIZER_MAP.get(null).forEach(initializer -> listeners.add((PreparableReloadListener)initializer.init(registryAccess, commandSelection, reloadableServerResources)));
    }

    public void applyModifiers(EventPriority eventPriority, ResourceLocation location, T value) {
        List<ObjectModifier<ObjectModifier, S, D, ?>> modifiers;
        Map<ResourceLocation, List<ObjectModifier<T, S, D, ?>>> assignedModifiers = this.prioritizedAssignedModifiers.get(eventPriority);
        if (assignedModifiers != null && (modifiers = assignedModifiers.get(location)) != null) {
            modifiers.forEach(modifier -> modifier.modify(value));
        }
    }

    protected void apply(Map<ResourceLocation, JsonElement> map, ResourceManager resourceManager, ProfilerFiller profilerFiller) {
        SelectionSpace selectionSpace = this.selectionSpace;
        String type = this.type;
        int groupsLoaded = 0;
        ObjectModifierSerializerRegistry<T, S, D> serializerRegistry = this.serializerRegistry;
        Function<ResourceLocation, D> additionalDeserializationGetter = this.additionalDeserializationGetter;
        boolean logSkipping = this.logSkipping;
        boolean allowPriority = this.allowPriority;
        EnumMap<EventPriority, Map<ResourceLocation, List<ObjectModifier<T, S, D, ?>>>> prioritizedAssignedModifiers = this.prioritizedAssignedModifiers;
        prioritizedAssignedModifiers.clear();
        for (Map.Entry<ResourceLocation, JsonElement> entry : map.entrySet()) {
            ResourceLocation resourcelocation = entry.getKey();
            try {
                ObjectModifierGroup<T, S, D> group = ObjectModifierGroup.deserialize(resourcelocation.toString(), entry.getValue().getAsJsonObject(), additionalDeserializationGetter.apply(resourcelocation), serializerRegistry, logSkipping, allowPriority);
                Map assignedModifiers = prioritizedAssignedModifiers.computeIfAbsent(group.priority(), __ -> new HashMap());
                List<ObjectModifier<T, S, D, ?>> groupModifiers = group.modifiers();
                for (ResourceLocation selectedLocation : group.selector().select(selectionSpace)) {
                    assignedModifiers.computeIfAbsent(selectedLocation, __ -> new ArrayList()).addAll(groupModifiers);
                }
                ++groupsLoaded;
            }
            catch (JsonParseException | IllegalArgumentException jsonparseexception) {
                Blueprint.LOGGER.error("Parsing error loading " + type + " Modifier Group: {}", (Object)resourcelocation, (Object)jsonparseexception);
            }
        }
        Blueprint.LOGGER.info(type + " Modification Manager has loaded {} modifier groups", (Object)groupsLoaded);
        this.selectionSpace = consumer -> {};
    }

    @FunctionalInterface
    public static interface Initializer<OM extends ObjectModificationManager<?, ?, ?>> {
        public OM init(RegistryAccess.Frozen var1, Commands.CommandSelection var2, ReloadableServerResources var3);
    }
}

